﻿var IntWebCmd = {

    m_QuestionTag: [],
    m_LastCmdTime: "",
    m_Log: null,
    m_szLabel : "" ,
    m_bEnable : false ,


    init: function (log , enable){
        this.m_Log = log;
        this.m_bEnable = enable;
        return;
    },

    setEnable: function( enable ){
        this.m_bEnable = enable;
    },


    //
    //  Utiliser pour fin de debogage seulement . Nous tentons de garder les dernieres 10 questions
    //  
    //  Pas utilise pour le moment mais si necessaire, a utiliser dans la fonction examineIntwebPage
    //
    push: function (tag) {

        var tagInfo = [];
        tagInfo.tagquestion = tag;
        tagInfo.time = new Date();

        if (this.m_QuestionTag.length > 10 )
            this.m_QuestionTag.shift() ;

        this.m_QuestionTag.push(tagInfo);
        return ;
    },

  
    //
    //  Methode qui permet de tracer les 10 dernieres questions du questionnaire lorsque l'agent
    //  a appuyer sur le bouton back
    //
    Dump: function () {

        if (typeof this.m_Log != "function" || this.m_Log == null)
            return;


        try{
            this._warning("we have detected back space. Tracing the last 10 questions...");
            for( index = 0 ; index < this.m_QuestionTag.length ; index++ )
            {
                var question = this.m_QuestionTag[index];
                this._warning("question tag: " + question.tagquestion + "-- read at time: ", question.date.getTime());
            }
        }
        catch( e )
        {

        }
    },


    Reset: function () {
        if( this.m_QuestionTag.length > 0)
            this.m_QuestionTag.splice(0, this.m_QuestionTag.length);
    },


    //
    // test sur la comparaison des temps. .... 
    // 
    preventBackNew: function (dateUTC, cmd) {
        var bRet = false;

        if (this.m_LastCmdTime.length == 0) {
            this.m_LastCmdTime = dateUTC;
            return bRet;
        }

        if (dateUTC <= this.m_LastCmdTime) {
            this._error("preventBackNew> back in time for command  " + cmd + ". Time  " + this.m_LastCmdTime + " > " + dateUTC);
            window.history.forward(1);
            return true;
        }

        return false ;
    },

    //
    //  On tente de determine si l'agent a appuyer sur le bouton back. Si c'est le cas nous le revoyons
    //  a la page precedante du questionnaire.
    //
    //  Ca marche si la page est dans le cache de internet explorer ou autre browser
    //
    preventBack: function (dateUTC, label) {

        if (typeof dateUTC != "string" ) {
            this._debug("preventBack> no date time available in intweb page... enable: ", this.m_bEnable);
            return false;
        } 

        try
        {
            var utc = dateUTC.split("T");
            if (utc.length < 2)
                return false;

            var date = utc[0].split("-");
            var time = utc[1].replace("Z", "").split(":");

            var second = time[2].split(".");

            var commandDate = new Date(date[0], date[1] - 1, date[2], time[0], time[1], second[0], second[1]);

            var bRet = false;
            if (this.m_LastCmdTime.length == 0) {
                this.m_LastCmdTime = commandDate;
                this.m_szLabel = label ? label : "";
                return bRet;
            }

            if (commandDate <= this.m_LastCmdTime) {


                if (this.m_bEnable == true) {
                    this._error("preventBack> The agent press back button on tag " + this.m_szLabel + ". We force the agent to stay on is page to avoid undesired behavior");
                    window.history.forward(1);
                    return true;
                }

                this._error("preventBack> The agent press back button on question tag " + this.m_szLabel + ". He is now on question " + label);
                return false;
            }
        } catch (e) {

            return false;
        }

        this.m_szLabel = label ? label : "";
        this.m_LastCmdTime = commandDate;
        return false;
    },



    _error: function (message) {

        if (typeof this.m_Log != "function")
            return;

        this.m_Log(LogLevel.error, message);
        return ;
    },

    _warning: function (message) {

        if (typeof this.m_Log != "function")
            return;

        this.m_Log(LogLevel.warning, message);
        return;
    },

    _debug: function (message) {

        if (typeof this.m_Log != "function")
            return;

        this.m_Log(LogLevel.debug, message);
        return;
    }
}



var IntWeb = {

    //
    //IntWeb.m_bClose       : la session intweb est ferme -> m_bClose = true
    //IntWeb.m_bInprogress  : la requete n'est pas termine
    //IntWeb.m_onLog        : callback pour les logs...
    //IntWeb.m_onConsole   : Permet d'envoyer les messages a la console.
    //

    m_bClosed: true,
    m_bSimulated: false,
    m_bInprogress: false,
    m_bPreviousSession: false,
    m_bFirstInwebPage: true,
    m_Http: null,
    m_iError: 0,
    m_iMaxError: 3,
    m_IntWebUrl: "",
    m_BlendUrl: "",
    m_Data: "",
    m_iTimeoutId: 0,
    m_onLog: "",
    m_onConsole: "",

    Init: function (callback, blendUrl) {

        if (typeof blendUrl == "string")
            this.m_BlendUrl = blendUrl;

        if (typeof callback == "object") {
            this.m_onLog = callback.onLog;
            this.m_onConsole = callback.onConsole;
        }
    },

    enableNewCallButton: function (bTimerExpired) {

        var shareframe = gClassManager.getSharedFrame();
        if (bTimerExpired == false && IntWeb.m_bNoSampleAvailable == true)
            return;

        IntWeb.m_bNoSampleAvailable = false;
        enableIntWebCtrl(shareframe, NewCallBtnId, true);
        return;
    },

    disableNewCallButtonOnNoSample: function (projectType) {

        if (projectType != _MODULE_PREVIEW)
            return;

        this.m_bNoSampleAvailable = true;
        var shareframe = gClassManager.getSharedFrame();
        enableIntWebCtrl(shareframe, NewCallBtnId, false);
        setTimeout(function () { IntWeb.enableNewCallButton(true) }, 2000);
        return;
    },

    //
    //  IntWeb.createHttpOject()
    //
    //  Creation de l'objet HTTP pour l'envoie de la requete intweb
    //
    //
    //
    createHttpOject: function () {
        if (window.XMLHttpRequest == null) {

            this.error("IntWeb.createHttpOject> not able to create http class object. Wrong browser version.");
            return;
        }


        if (this.m_Http != null) {
            this.m_Http.abort();
        }

        this.m_Http = new XMLHttpRequest();
        this.m_Http.ontimeout = this.onTimeout;
        this.m_Http.onerror = this.onError;
        this.m_Http.onreadystatechange = this.onStateChange;

        return;
    },

    //
    //  IntWeb.Sleep ...
    //  Energivore mais ca marche pour effectuer un sleep synchrone...
    //
    Sleep: function (millisecond) {

        var date = new Date();
        var curDate = null;
        do {

            curDate = new Date();

        } while (curDate - date < millisecond);

        return;
    },

    ClosePreviousSession: function (url, sessionguid) {

        if (typeof url != "string" || typeof sessionguid != "string" || url.length == 0 || sessionguid.length == 0)
            return;


        this.m_bPreviousSession = true;
        var data = 'IMODE=3&IACTION=27' + '&sessionguid=' + sessionguid;
        this.SendAsync(url, data, "previous session");
        return;
    },

    SendAsync: function (url, data, reason) {

        if (typeof url != "string" || typeof data != "string" || url.length == 0 || data.length == 0)
            return;

        if (typeof reason != "string")
            reason = "current session";

        this.createHttpOject();

        this.m_iTimeoutId = 0;
        this.m_bInprogress = true;

        this.info("IntWeb.SendAsync> sending close session request in async mode: " + url + "?" + data + " session:" + reason);
        this.m_Http.open("POST", url, true);
        this.m_Http.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
        this.m_Http.send(data);

        //
        //  Avec chrome et sans les autres browser la version sync des appels ajax
        //  Avec chrome et sans les autres browser la version sync des appels ajax
        //  son non supporte avec les unload des documents. Si un requete ajax est fin
        //  elle doit etre imperativement async
        //
        this.Sleep(50);
        return;
    },

    //
    //  IntWeb.Close 
    //  
    //  Cette methode permt
    //
    Close: function (bAsync) {

        if (this.m_bClosed == true) {
            this.info("IntWeb.Close> intweb session is already closed... session guid: " + AgentAssignment.getSessionGuid());
            return "success";
        }

        if (this.m_bInprogress == true) {
            this.debug("IntWeb.Close> There is a close session request already in progress...");
            return "success";
        }

        this.createHttpOject();

        try {
            var sampleManager = gClassManager.getNoSampleClass();
            if (typeof sampleManager == "object" && sampleManager != null) {

                // Retrait de l'icone no sample available lorsque l'on change ou nous choisisons un nouveau projet si present a l'ecran.
                sampleManager.Reset();
            }
        }
        catch (e) {

        }

        var projectId = AgentAssignment.getCurrentCatiModuleId();
        if (projectId == 0) {
            this.info("IntWeb.Close> There is no need to close intweb session. Migth be Blend project with no associated module or the agent just open a new session");
            this.m_bFirstInwebPage = true;
            return "success"
        }

        var IntWebProperties = AgentAssignment.GetCatiProperties(projectId);
        if (IntWebProperties == null || IntWebProperties.m_CatiUrl == null || typeof IntWebProperties != "object" || typeof IntWebProperties.m_CatiUrl != "string") {
            this.info("IntWeb.Close> The agent did not select project. No need to close intweb session");
            return "success";
        }

        if (IntWebProperties.m_CatiUrl.length == 0) {
            this.warning("IntWeb.Close> Not able to send close session to intweb for project id " + projectId + ". May be no project has been selected");
            return "simulate";
        }

        this.m_IntWebUrl = IntWebProperties.m_CatiUrl;
        this.m_Data = 'IMODE=3&IACTION=27' + '&sessionguid=' + AgentAssignment.getSessionGuid();

        if (typeof bAsync == "boolean" && bAsync == true )
            this.SendAsync(this.m_IntWebUrl, this.m_Data);
        else
            this.Send(this.m_IntWebUrl, this.m_Data);

        return "success";
    },

    //
    //   IntWeb.Send
    //
    //  Envoie de la requete au service intweb.
    //
    //
    Send: function (url, data) {
        if (typeof this.m_Http != "object") {
            this.error("IntWeb.send> Not able to send close session to intweb... No http objet.");
            return;
        }

        this.m_iTimeoutId = 0;

        this.m_bInprogress = true;
        this.debug("IntWeb.send> sending close session requet: " + url + "?" + data);
        this.m_Http.open("POST", url, false);
        this.m_Http.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
        this.m_Http.send(data);

        if (this.m_Http.status == 200) {
            this.info("IntWeb.send> The intweb session is now closed: " + url + "?" + data);
            this.m_bInprogress = false;
            this.Closed();
            return;
        }

        IntWeb.error("Intweb.send> Close IntWeb session failed on host: " + IntWeb.m_IntWebUrl + ". Trying to resend it  --  http error: " + IntWeb.m_Http.status);


        var bExit = false;
        while (bExit == false) {

            this.Sleep(300);
            this.info("IntWeb.send> resending close intweb session request on http error. " + url + "?" + data);

            var result = this.Resend();
            switch (result) {
                case "maxretries":
                    bExit = true;
                    break;

                case "success":
                    bExit = true;
                    this.Closed();
                    break;

                case "pendingrequest":
                case "error":
                default:
                    break;
            }
        }
    },

    //
    //  IntWeb.onStateChange 
    //
    //  Callback necessaire a l'object http XMLHttpRequest . A chaque fois que la requete change
    //  d'etat , cette fonction est appele 
    //
    //  Selon la document l'etat 4 est lorsque la requete est compelete
    //  
    //
    onStateChange: function () {

        if (IntWeb.m_Http.readyState == 1 || IntWeb.m_Http.readyState == 2 || IntWeb.m_Http.readyState == 3)
            return;

        IntWeb.m_iTimeoutId = 0;
        IntWeb.m_bInprogress = false;

        switch (IntWeb.m_Http.status) {
            case 200:
                IntWeb.info("IntWeb.onStateChange> IntWeb session is now closed... host: " + IntWeb.m_IntWebUrl);
                IntWeb.Closed( true );
                break;

            default:

                if (IntWeb.m_Http.status > 0 && IntWeb.m_Http.status < 500) {
                    IntWeb.error("IntWeb.send> Close IntWeb session failed on host: " + IntWeb.m_IntWebUrl + ". No need to resend the request. The http request will be resend only if the http status >= 500 -- http status: " + IntWeb.m_Http.status);
                    break;
                }

                //
                //  Acording to the internet status of 0 means aborted.
                //
                var status = IntWeb.m_Http.status;
                if (status == 0)
                    status = "aborted";

                IntWeb.Close();
                IntWeb.warning("IntWeb.send> Close IntWeb session failed on host: " + IntWeb.m_IntWebUrl + ". Trying to resend it  --  http error: " + status);
                break;
        }
    },

    //
    //  IntWeb.onError 
    //
    // Callback d'erreur de l'objet XMLHttpRequest. Si nous voulons etre fault tolerant nous devrions
    //
    //

    onError: function (e) {
        IntWeb.error("IntWeb.OnError> Send intweb close command failed -- reason: " + IntWeb.m_Http.statusText);
        IntWeb.Closed(false);         
        return;
    },

    //
    //  IntWeb.onTimeout 
    //
    //  Callback pour les timeouts  de l'objet XMLHttpRequest
    //
    //  
    //
    //

    onTimeout: function () {
        IntWeb.error("IntWeb.OnError> request timeout occurred. The intweb close session did not respond on time...");
        IntWeb.Closed();
        return;
    },

    forceReload: function () {
        this.m_bFirstInwebPage = true;
        return;
    },

    Closed: function (bLog) {

        if (typeof bLog != "boolean")
            bLog = false;

        this.m_bInprogress = false;
        if (this.m_bPreviousSession == true) {
            if ( bLog == true)
                this.debug("Intweb.Closed> Previous session is now close.");

            this.m_bPreviousSession = false;
            return;
        }

        this.m_bClosed = true;
        this.m_bFirstInwebPage = true;
        if( typeof bLog == "boolean" && bLog == true )
            this.debug("Intweb.Closed> intweb session is now closed.");
    },

    Open: function () {

        this.m_bClosed = false;
        this.m_bSimulated = false;
        this.debug("Intweb.Open> intweb session is now opened.");
        return;
    },

    Reset: function () {

        if (IntWeb.m_iTimeoutId != 0) {
            clearTimeout(IntWeb.m_iTimeoutId);
            IntWeb.m_iTimeoutId = 0;
        }

        IntWeb.m_iError = 0;
        IntWeb.m_Data = "";
        IntWeb.m_IntWebUrl = "";
        return;
    },

    SetBlendUrl: function( blendUrl ){

    },

    Resend: function () {
        if (IntWeb.m_iTimeoutId != 0)
            return "pendingrequest";

        IntWeb.m_iError++;
        if (IntWeb.m_iError >= IntWeb.m_iMaxError) {
            IntWeb.error("IntWeb.Resend> IntWeb session is not closed because we reach the maximun retries -- host:  " + IntWeb.m_IntWebUrl);
            IntWeb.Reset();
            return "maxretries";
        }

        IntWeb.createHttpOject();

        IntWeb.m_bInprogress = true;
        IntWeb.m_Http.open("POST", IntWeb.m_IntWebUrl, false);
        IntWeb.m_Http.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
        IntWeb.m_Http.send(IntWeb.m_Data);

        var szSuccess = "error"
        if (IntWeb.m_Http.status == 200)
            szSuccess = "success";
        else
            IntWeb.error("Intweb.Resend> Sending Intweb close session request failed  " + IntWeb.m_IntWebUrl + " -- http error: " + IntWeb.m_Http.status);

        return szSuccess;
    },

    SimulateQuit: function (shareframe) {

        if (this.m_bSimulated == true)
            return;

        this.m_bSimulated = true;
        if (typeof shareframe != "object" || shareframe == null || typeof shareframe.document != "object" || shareframe.document == null) {
            this.warning("intWeb.SimulateQuit> not able to simulate intWeb QUIT button to close intweb session. Input parameter is not an html document");
            return;
        }

        var _inputs = shareframe.document.getElementsByTagName("input");
        if (_inputs == null) {
            this.debug("intWeb.SimulateQuit> Not an IntWeb document... Not able to close intweb session");
            return;
        }

        try {
            var i;
            for (i = 0; i < _inputs.length; i++) {
                if (_inputs[i].name.toUpperCase() === 'IACTION-3') {
                    var _action = _inputs[i];
                    if (_action != null) {
                        _action.click();
                        this.info("intWeb.SimulateQuit> intweb session is now closed");
                        break;
                    }
                }
            }
        } catch (e) {
            this.warning("intWeb.SimulateQuit> caught a java script exception when trying to close intweb session. Not able to close intweb session -- reason: " + e.message);
        }

        return;
    },

    info: function (message) {
        try {
            if (typeof this.m_onLog == "function") {
                this.m_onLog(LogLevel.info, message);
            }
        }
        catch (e) {
        }

        return;
    },


    debug: function (message) {
        try {
            if (typeof this.m_onLog == "function") {
                this.m_onLog(LogLevel.debug, message);
            }
        }
        catch (e) {
        }

        return;
    },

    warning: function (message) {

        try {

            if (typeof this.m_onLog == "function") {
                this.m_onLog(LogLevel.warning, message);
            }
        }
        catch (e) {
        }

        return;
    },

    error: function (message) {

        try {

            if (typeof this.m_onLog == "function") {
                this.m_onLog(LogLevel.error, message);
            }
        }
        catch (e)
        {
        }

        return;
    },




    invokeIntWebPage: function (url) {

        try {
            var intWebFrame = gClassManager.getSharedFrame();
            intWebFrame.location = url;
            this.Open();
        }
        catch (e)
        {
            this.error("GetIntWebPage> not able to login to intweb pages -- exception: " + e.message);
        }
       
        return;
    },

    initializeAgentSession: function (url, bLoad) {

        try {
            //
            //  bLoad = true 
            //  Propre au projet blend sans projet associe car nous ne sommes pas dans une page 
            //  intweb. La page intweb est presente si et seulement si nous avons un projet associe au projet systeme de type blend.
            //

            if (typeof url != "string" || (typeof bLoad == "boolean" && bLoad == true)) {
                this.StartSession(url);
                return;
            }

            if (this.m_bFirstInwebPage == false) {
                return;
            }


            this.info("initializeAgentSession> This is the first intweb page ... starting the intweb session");
            this.StartSession(url);      
        }
        catch (e) {
            this.error("initializeAgentSession> not able to load project setting... caugth a javascript exception : " + e.message);
        }
    },

    //
    //  Intweb.StartSession est appele une seule 
    //
    StartSession: function (url) {

        if (this.isIntweb(url) == true) {
            this.m_bFirstInwebPage = false;
        }

        var onExecuteCmd = gClassManager.getCloseSentinelFrame().executeProntoCmd;
        var onCatiOnlySetDisplay = gClassManager.getToolbar().onCatiOnlySetDisplay;
        var onAutomaticProjectSetDisplay = gClassManager.getToolbar().onAutomaticProjectSetDisplay;

        var callback = { onExecuteProntoCmd: onExecuteCmd, onAutomaticProjectSetDisplay: onAutomaticProjectSetDisplay, onCatiOnlySetDisplay: onCatiOnlySetDisplay };
        AgentAssignment.init(callback);

        //
        // nous allons chercher les caractisques du projet sur laquelle l'agent travail. ProntoModuleId , catiModuleId , url de intweb etc.
        //
        var bLoaded = AgentAssignment.GetProjectAssignment();
        if (bLoaded)
            this.info("Intweb.StartSession> project assignment has been loaded in browser");


        gClassManager.getConfigManager().getAdvanceSetting(true);

        //
        //  Demarrage du chronometre de pause au chargment de la premiere page de Intwev
        //
        //  CallStats.open() -> Demarrage des statistique interne pour fin de debogage seulement
        //  gClassManager.getCustomDialPad().init() -> initialisation du dialpad pour les projets manuels
        //  this.Open() -> indique nous avons une session intweb d'ouverte. C'est la responsabite de voxco.agent de la ferme
        //
        PAUSERequest.startChronometer(true);
        CallStats.open();
        gClassManager.getCustomDialPad().init(ReadUserId("CloseSentinel.onMainLoad", null, false));

        this.Open();
        setPlayingRecording(false);
    },

    isFirstIntwebPage: function () {
        return this.m_bFirstInwebPage;
    },

    isIntweb: function (url) {

        //
        //  m_BlendUrl          -> projet blend sans projet associe .
        //  /survey/intweb.dll  -> page intweb 
        //
        var bIntweb = true;
        if (url.toLowerCase().indexOf('/survey/intweb.dll') < 0 && url.indexOf( this.m_BlendUrl ) < 0 )
            bIntweb = false;

        return bIntweb;
    }

}